<?php
namespace App\Observers;

use App\Models\Task;
use App\Models\TaskLog;
use Illuminate\Support\Facades\Auth;

class TaskObserver {
    public function created(Task $task) {
        TaskLog::create([
            'task_id'     => $task->id,
            'user_id'     => Auth::id(),
            'action'      => 'created',
            'description' => "Task created with title: {$task->title}",
        ]);
    }

    public function updated(Task $task) {
        if ($task->wasChanged('status')) {
            $oldStatus = str_replace('_', ' ', $task->getOriginal('status'));
            $newStatus = str_replace('_', ' ', $task->status);
            TaskLog::create([
                'task_id'     => $task->id,
                'user_id'     => Auth::id(),
                'action'      => 'status_changed',
                'description' => "Task status changed from {$oldStatus} to {$newStatus}",
                'data'        => $task->getChanges(),
            ]);
        } else {
            if ($task->isDirty()) {
                TaskLog::create([
                    'task_id'     => $task->id,
                    'user_id'     => Auth::id(),
                    'action'      => 'updated',
                    'description' => "Task updated",
                    'data'        => $task->getChanges(),
                ]);
            }
        }
    }

}
