<?php
namespace App\Notifications;

use App\Models\EmailTemplate;
use App\Models\Task;
use App\Utilities\Overrider;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class TaskStatusUpdated extends Notification {
    use Queueable;

    protected $task;
    private $template;
    private $replace = [];

    /**
     * Create a new notification instance.
     */
    public function __construct(Task $task) {
        Overrider::load("Settings");
        $this->task         = $task;
        $this->task->status = str_replace('_', ' ', $this->task->status);

        $this->template = EmailTemplate::where('slug', 'TASK_STATUS_UPDATED')
            ->where('tenant_id', request()->tenant->id)
            ->first();

        $this->replace['title']   = $this->task->title;
        $this->replace['status']  = $this->task->status;
        $this->replace['dueDate'] = $this->task->due_date;
        $this->replace['taskUrl'] = route('tasks.show', $this->task->id);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array {
        return ['database'];
    }

    public function toDatabase($notifiable) {
        $message = processShortCode($this->template->email_body, $this->replace);
        return [
            'subject' => $this->template->subject,
            'message' => $message,
        ];
    }
}
