<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class EmployeeBenefitDeduction extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'employee_benefits_deductions';

    protected $fillable = ['employee_id', 'name', 'amount', 'amount_type', 'type'];

    protected function amount(): Attribute {
        $decimal_place = get_tenant_option('decimal_places', 2);

        return Attribute::make(
            get: fn(string $value) => number_format($value, $decimal_place, '.', ''),
        );
    }

}