<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckEmployeeIP {
    public function handle(Request $request, Closure $next): Response {
        if (get_tenant_option('ip_restriction_status', 0) == 1) {
            $allowedIps = explode(',', get_tenant_option('allowed_ip_addresses', ''));
            $userIp     = $request->ip();

            if (! in_array($userIp, $allowedIps)) {
                return back()->with('error', 'Access denied: Unauthorized IP Address');
            }
        }

        return $next($request);
    }
}
